import { CronModule } from './modules/cron/cron.module';
/* eslint-disable @typescript-eslint/no-unsafe-call */
/* eslint-disable @typescript-eslint/no-unsafe-return */
/* eslint-disable @typescript-eslint/no-unsafe-member-access */
import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { MongooseModule } from '@nestjs/mongoose';
import { ConfigModule } from '@nestjs/config';
import { NotFoundMiddleware } from '@common/middleware/not-found.middleware';
import { AuthModule } from '@modules/auth/auth.module';
import { UsersModule } from '@modules/users/users.module';
import { BusinessModule } from '@modules/business/business.module';
import { ShoppingsModule } from './modules/shoppings/shoppings.module';
import { ProductsModule } from './modules/products/products.module';
import { NotificationsModule } from './modules/notifications/notifications.module';
import { InventoryModule } from './modules/inventory/inventory.module';
import { SalesModule } from './modules/sales/sales.module';
import { MetricsModule } from './modules/metrics/metrics.module';
import { TaxesModule } from './modules/taxes/taxes.module';
import { CashCountModule } from './modules/cash-count/cashcount.module';
import { ScheduleModule } from '@nestjs/schedule';

@Module({
  imports: [
    CronModule,
    AuthModule,
    UsersModule,
    BusinessModule,
    ProductsModule,
    ShoppingsModule,
    NotificationsModule,
    InventoryModule,
    SalesModule,
    MetricsModule,
    TaxesModule,
    CashCountModule,
    ConfigModule.forRoot({ isGlobal: true }),
    MongooseModule.forRoot('mongodb://localhost:27017/lotto-app', {
      connectionFactory: (connection) => {
        connection.set('debug', false);
        return connection;
      },
    }),
    ScheduleModule.forRoot(),
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(NotFoundMiddleware).forRoutes('*');
  }
}
