export interface Business {
  _id: string;
  name: string;
  address: string;
  postal: string;
  city: string;
  state: string;
  email?: string[];
  phone?: string[];
  mobile?: string[];
  business_hours?: string[];
  createdAt?: string;
  updatedAt?: string;
}

export interface UserData {
  _id?: string;
  businessId: Business;
  email: string;
  password: string;
  photo?: string;
  active?: boolean;
  role?: 'admin' | 'user' | 'super';
  token?: string;
  createdAt?: string;
  updatedAt?: string;
}

export interface Product {
  _id?: string;
  businessId?: string;
  userId?: UserData;
  identificador: string;
  categoria: string;
  clave: string;
  comision: number;
  observaciones: string;
  code_bar: string;
  photo?: string;
  exists: boolean;
  bet: boolean;
  createdAt?: string;
  updatedAt?: string;
}

export interface Item {
  _id?: string;
  productId: Product;
  product?: Product;
  fecha?: Date;
  sorteo?: string;
  dotacion: number;
  costo_total: number;
  precio_total: number;
  pago_anticipado: number;
  saldo_x_pagar: number;
  saldo_anterior: number;
  devolucion?: number;
  identificador: string;
  createdAt?: Date;
  updatedAt?: Date;
}

export interface ItemToSave {
  _id?: string;
  productId: string;
  fecha?: Date;
  sorteo?: string;
  dotacion: number;
  costo_total: number;
  precio_total: number;
  pago_anticipado: number;
  saldo_x_pagar: number;
  devolucion?: number;
  identificador: string;
  createdAt?: Date;
  updatedAt?: Date;
}

export interface SaldosToSave {
  _id?: string;
  productId: string;
  identificador: string;
  fecha: Date;
  sorteo: string;
  saldo_anterior: number;
  pago_anticipado: number;
  saldo_x_pagar: number;
  createdAt?: Date;
  updatedAt?: Date;
}

export interface DevolucionesToSave {
  _id?: string;
  productId: string;
  identificador: string;
  fecha: string;
  sorteo: string;
  dotacion: number;
  devolucion: number;
  createdAt?: Date;
  updatedAt?: Date;
}

export interface ShoppingsToSave {
  _id?: string;
  businessId: string;
  userEmail: string;
  products: ItemToSave[];
  saldos: SaldosToSave[];
  devoluciones: DevolucionesToSave[];
  createdAt?: Date;
  updatedAt?: Date;
}

export interface ResultadoResumen {
  _id: string;
  userEmail: string;
  totalProducts: {
    costo_total: number;
    precio_total: number;
    saldo_x_pagar: number;
  };
  totalSaldos: {
    pago_anticipado: number;
    saldo_x_pagar: number;
  };
  totalDevoluciones: {
    devoluciones: number;
  };
  products: Item[];
  saldos: SaldosToSave[];
  devoluciones: DevolucionesToSave[];
  createdAt?: string;
  updatedAt?: string;
}

export interface DEVOLUCIONResumen {
  id: any;
  identificador: string;
  businessId: any;
  fecha: Date;
  sorteo: string;
  total_comprado: number;
  total_vendido: number;
  diferencia: number;
  caducado: boolean;
}

export interface Notify {
  userId?: any;
  title: string;
  body: string;
  image?: string;
  data: {
    type:
      | 'success'
      | 'danger'
      | 'warning'
      | 'info'
      | 'primary'
      | 'secondary'
      | 'light'
      | 'dark';
  };
}
