import { IsString, IsOptional, IsArray } from 'class-validator';
import { Type } from 'class-transformer';

export class CreateBusinessDto {
  @IsString()
  name: string;

  @IsString()
  address: string;
  
  @IsString()
  agentName: string;

  @IsString()
  postal: string;

  @IsString()
  city: string;

  @IsString()
  state: string;

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  @Type(() => String)
  email: string[];

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  @Type(() => String)
  phone: string[];

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  @Type(() => String)
  mobile: string[];

  @IsOptional()
  @IsArray()
  @IsString({ each: true })
  @Type(() => String)
  business_hours: string[];
}

export class UpdateEnterpriseDto extends CreateBusinessDto {
  @IsString()
  _id: string;
}
