import { IsArray, IsNumber, IsString, ValidateNested } from 'class-validator';
import { Type } from 'class-transformer';
import { PartialType } from '@nestjs/swagger';

class ValesDto {
  @IsString()
  concepto: string;

  @IsString()
  fecha: string;

  @IsNumber()
  monto: number;
}

class DenominacionDto {
  @IsNumber()
  denominacion: number;

  @IsNumber()
  cantidad: number;
}

class ArqueoDto {
  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => DenominacionDto)
  monedas: DenominacionDto[];

  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => DenominacionDto)
  billetes: DenominacionDto[];
}

export class CreateCorteCajaDto {
  @IsString()
  businessId: string;

  @IsString()
  userEmail: string;

  @IsNumber()
  venta_producto: number;

  @IsNumber()
  efvo_producto: number;

  @IsNumber()
  pago_producto: number;

  @IsNumber()
  pago_producto_efvo: number;

  @IsNumber()
  tarjeta_producto: number;

  @IsNumber()
  tarjeta_producto_tax: number;

  @IsNumber()
  venta_servicio: number;

  @IsNumber()
  pago_servicio: number;

  @IsNumber()
  tarjeta_servicio: number;

  @IsNumber()
  tarjeta_servicio_tax: number;

  @IsNumber()
  venta_apuesta: number;

  @IsNumber()
  efvo_apuesta: number;

  @IsNumber()
  pago_apuesta: number;

  @IsNumber()
  pago_apuesta_efvo: number;

  @IsNumber()
  tarjeta_apuesta: number;

  @IsNumber()
  tarjeta_apuesta_tax: number;

  @IsNumber()
  efvo_ttl_venta: number;

  @IsNumber()
  vales: number;

  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => ValesDto)
  vales_items: ValesDto[];

  @IsNumber()
  efvo_real_venta: number;

  @IsNumber()
  venta_total: number;

  @IsNumber()
  fondo_caja: number;

  @IsNumber()
  diferencia: number;

  @IsNumber()
  retiro_efectivo: number;

  @IsNumber()
  efvo_contado: number;

  @IsNumber()
  caja_recibe: number;

  @IsNumber()
  caja_entrega: number;

  @IsString()
  observaciones: string;

  @ValidateNested()
  @Type(() => ArqueoDto)
  arqueo: ArqueoDto;

  @IsString()
  turno: string;
}

export class UpdateCorteCajaDto extends PartialType(CreateCorteCajaDto) {
  @IsString()
  _id: string;
}
