import {
  IsBoolean,
  IsMongoId,
  IsNotEmpty,
  IsNumber,
  IsOptional,
  IsString,
} from 'class-validator';
import { Types } from 'mongoose';
import { PartialType } from '@nestjs/swagger';

export class CreateProductDto {
  @IsNotEmpty()
  @IsMongoId()
  businessId: Types.ObjectId;

  @IsNotEmpty()
  @IsMongoId()
  userId: Types.ObjectId;

  @IsString()
  identificador: string;

  @IsString()
  categoria: string;

  @IsString()
  clave: string;

  @IsNumber()
  comision: number;

  @IsOptional()
  @IsString()
  observaciones?: string;

  @IsOptional()
  @IsString()
  code_bar?: string;

  @IsOptional()
  @IsString()
  photo?: string;

  @IsBoolean()
  exists: boolean;

  @IsBoolean()
  bet: boolean;
}

export class UpdateProductDto extends PartialType(CreateProductDto) {
  @IsNotEmpty()
  _id: Types.ObjectId;
}
