import { PartialType } from '@nestjs/swagger';
import { Type } from 'class-transformer';
import {
  IsMongoId,
  IsOptional,
  IsNumber,
  IsString,
  IsArray,
  ValidateNested,
} from 'class-validator';

export class CreateSaldosDto {
  @IsMongoId()
  productId: string;

  @IsString()
  identificador: string;

  @IsOptional()
  fecha?: Date;

  @IsOptional()
  @IsString()
  sorteo?: string;

  @IsNumber()
  saldo_anterior: number;

  @IsNumber()
  pago_anticipado: number;

  @IsNumber()
  saldo_x_pagar: number;
}

export class CreateDevolucionesDto {
  @IsMongoId()
  productId: string;

  @IsString()
  identificador: string;

  @IsOptional()
  fecha?: Date;

  @IsOptional()
  @IsString()
  sorteo?: string;

  @IsNumber()
  dotacion: number;

  @IsNumber()
  devolucion: number;
}

export class CreateItemDto {
  @IsMongoId()
  productId: string;

  @IsOptional()
  fecha?: Date;

  @IsOptional()
  @IsString()
  sorteo?: string;

  @IsOptional()
  @IsString()
  photo?: string;

  @IsNumber()
  dotacion: number;

  @IsNumber()
  costo_total: number;

  @IsNumber()
  precio_total: number;

  @IsNumber()
  pago_anticipado: number;

  @IsNumber()
  saldo_x_pagar: number;

  @IsOptional()
  @IsNumber()
  devolucion?: number;

  @IsOptional()
  @IsString()
  identificador?: string;
}

export class CreateShoppingDto {
  @IsMongoId()
  businessId: string;

  @IsString()
  userEmail: string;

  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => CreateItemDto)
  products: CreateItemDto[];

  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => CreateItemDto)
  saldos: CreateSaldosDto[];

  @IsArray()
  @ValidateNested({ each: true })
  @Type(() => CreateItemDto)
  devoluciones: CreateDevolucionesDto[];
}

export class UpdateShoppingDto extends PartialType(CreateShoppingDto) {
  @IsMongoId()
  _id: string;
}

export class UpdateItemDto extends PartialType(CreateItemDto) {
  @IsMongoId()
  _id: string;
}
