/* eslint-disable @typescript-eslint/no-unsafe-assignment */
import { AuthService } from './auth.service';
import { AuthController } from './auth.controller';
import { Module } from '@nestjs/common';
import { PassportModule } from '@nestjs/passport';
import { EmailModule } from '@modules/email/email.module';
import { MongooseModule } from '@nestjs/mongoose';
import { JwtModule } from '@nestjs/jwt';
import { UserSchema } from '@schemas/user.schema';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { CryptoService } from '@services/crypto.service';
import { MultimediaService } from '@services/multimedia.service';
import { UserLogsSchema } from '@schemas/user-logs.schema';

@Module({
  imports: [
    PassportModule,
    EmailModule,
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'userlogs', schema: UserLogsSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [AuthController],
  providers: [AuthService, JwtStrategy, CryptoService, MultimediaService],
  exports: [AuthService],
})
export class AuthModule {}
