import { RolesGuard } from '@common/guards/roles.guard';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { Module } from '@nestjs/common';
import { JwtModule } from '@nestjs/jwt';
import { MongooseModule } from '@nestjs/mongoose';
import { BusinessSchema } from '@schemas/business.schema';
import { BusinessService } from './business.service';
import { BusinessController } from './business.controller';
import { UsersModule } from '@modules/users/users.module';
import { ProductSchema } from '@schemas/product.schema';
import { SaleSchema } from '@schemas/sale.schema';
import { ShoppingSchema } from '@schemas/shopping.schema';
import { UserSchema } from '@schemas/user.schema';
import { CleanupService } from './cleanup.service';
import { NotificationSchema } from '@schemas/notification.schema';
import { BoxCashSchema } from '@schemas/box-cash.schema';
import { CashCountSchema } from '@schemas/cash-count.schema';
import { TaxesSchema } from '@schemas/taxes.schema';
import { ComisionSchema } from '@schemas/comision.schema';
import { UserLogsSchema } from '@schemas/user-logs.schema';

@Module({
  imports: [
    UsersModule,
    MongooseModule.forFeature([
      { name: 'business', schema: BusinessSchema },
      { name: 'products', schema: ProductSchema },
      { name: 'shoppings', schema: ShoppingSchema },
      { name: 'sales', schema: SaleSchema },
      { name: 'users', schema: UserSchema },
      { name: 'notifications', schema: NotificationSchema },
      { name: 'boxcash', schema: BoxCashSchema },
      { name: 'cashcount', schema: CashCountSchema },
      { name: 'taxes', schema: TaxesSchema },
      { name: 'comision', schema: ComisionSchema },
      { name: 'userlogs', schema: UserLogsSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [BusinessController],
  providers: [BusinessService, CleanupService, JwtStrategy, RolesGuard],
})
export class BusinessModule {}
