import { Injectable } from '@nestjs/common';
import { Connection, Types } from 'mongoose';
import { InjectConnection } from '@nestjs/mongoose';

@Injectable()
export class CleanupService {
  constructor(@InjectConnection() private readonly connection: Connection) {}

  async deleteBusinessData(businessId: string) {
    const collections = Object.keys(this.connection.collections);

    await Promise.all(
      collections.map(async (collectionName) => {
        const collection = this.connection.collection(collectionName);
        await collection.deleteMany({
          businessId: new Types.ObjectId(businessId),
        });
      }),
    );

    return {
      success: true,
      message: `Se eliminaron los datos del negocio ${businessId}`,
    };
  }
}
