import { HttpException, HttpStatus, Injectable } from '@nestjs/common';
import * as nodemailer from 'nodemailer';

@Injectable()
export class EmailService {
  private email = 'info@ctrlclick.com.mx';
  private transporter = nodemailer.createTransport({
    host: 'mail.ctrlclick.com.mx',
    port: 465,
    secure: true,
    auth: {
      user: 'info@ctrlclick.com.mx',
      pass: '?J(q?E}+-3zPO1A@',
    },
  });

  constructor() {}

  async sendEmail(to: string, subject: string, text: string) {
    try {
      const info = await this.transporter.sendMail({
        from: `"Crtl Click" <${this.email}>`,
        to,
        subject,
        text,
        html: `<div style="border: 1px solid #ddd; padding: 10px; border-radius: 4px;">
              ${text}
              <p style="font-size: 12px;">Para reportes puedes utilizar el siguiente enlace <a href="https://soporte.ctrlclick.com.mx" target="_blank">Abrir Ticket</a> o enviar correo a soporte@ctrlclick.com.mx</p>
              </div> `,
      });
      console.log('Correo enviado:', info.messageId);
      return info;
    } catch (error) {
      console.error('Error enviando correo:', error);
      throw new HttpException(
        'Error de servidor',
        HttpStatus.INTERNAL_SERVER_ERROR,
      );
    }
  }
}
