/*
https://docs.nestjs.com/controllers#controllers
*/

import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  Put,
  UseGuards,
  UseInterceptors,
} from '@nestjs/common';
import { GameType } from '@schemas/game-type.schema';
import { GameTypesService } from './gametypes.service';
import { ApiBearerAuth } from '@nestjs/swagger';
import { AuthGuard } from '@nestjs/passport';
import { JWToken } from '@dtos/general.interface';
import { Profile } from '@common/guards/profile.decorator';
import { AnyFilesInterceptor } from '@nestjs/platform-express';

@ApiBearerAuth()
@Controller('gametypes')
@UseGuards(AuthGuard('jwt'))
export class GameTypesController {
  constructor(private readonly gameTypesService: GameTypesService) {}

  @Post()
  @UseInterceptors(AnyFilesInterceptor())
  create(@Body() body: Partial<GameType>, @Profile() user: JWToken) {
    console.log(body);
    return this.gameTypesService.create(body, user.userId);
  }

  @Get()
  findAll(@Profile() user: JWToken) {
    return this.gameTypesService.findAll(user.userId);
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.gameTypesService.findOne(id);
  }

  @Put(':id')
  @UseInterceptors(AnyFilesInterceptor())
  update(@Param('id') id: string, @Body() body: Partial<GameType>) {
    return this.gameTypesService.update(id, body);
  }

  @Delete(':id')
  delete(@Param('id') id: string) {
    return this.gameTypesService.delete(id);
  }
}
