import { BoxCashSchema } from '@schemas/box-cash.schema';
import { MetricsService } from './metrics.service';
import { MetricsController } from './metrics.controller';
import { Module } from '@nestjs/common';
import { UserSchema } from '@schemas/user.schema';
import { BusinessSchema } from '@schemas/business.schema';
import { ProductSchema } from '@schemas/product.schema';
import { ShoppingSchema } from '@schemas/shopping.schema';
import { SaleSchema } from '@schemas/sale.schema';
import { MongooseModule } from '@nestjs/mongoose';
import { JwtModule } from '@nestjs/jwt';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { CashCountSchema } from '@schemas/cash-count.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'business', schema: BusinessSchema },
      { name: 'products', schema: ProductSchema },
      { name: 'shoppings', schema: ShoppingSchema },
      { name: 'sales', schema: SaleSchema },
      { name: 'boxcash', schema: BoxCashSchema },
      { name: 'cashcount', schema: CashCountSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [MetricsController],
  providers: [MetricsService, JwtStrategy],
})
export class MetricsModule {}
