/* eslint-disable @typescript-eslint/no-unsafe-member-access */
/* eslint-disable @typescript-eslint/no-unsafe-argument */
import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  Put,
  UploadedFile,
  UseGuards,
  UseInterceptors,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiBearerAuth } from '@nestjs/swagger';
import { ProductsService } from './products.service';
import { FileInterceptor } from '@nestjs/platform-express';
import { Profile } from '@common/guards/profile.decorator';
import { JWToken } from '@dtos/general.interface';

@ApiBearerAuth()
@Controller('products')
@UseGuards(AuthGuard('jwt'))
export class ProductsController {
  constructor(private readonly productService: ProductsService) {}

  @Post('deletemany')
  removeMany(@Body() body: any) {
    return this.productService.removeMany(body);
  }

  @Post()
  @UseInterceptors(FileInterceptor('new_photo'))
  create(@UploadedFile() photo: Express.Multer.File, @Body() body: any, @Profile() user: JWToken) {
    return this.productService.create(photo, body, user.userId);
  }

  @Get()
  findAll(@Profile() user: JWToken) {
    return this.productService.findAll(user.userId);
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.productService.findOne(id);
  }

  @Put('one')
  @UseInterceptors(FileInterceptor('new_photo'))
  updateOne(@UploadedFile() photo: Express.Multer.File, @Body() body: any) {
    const del: boolean = body.delete === 'si' ? true : false;
    delete body.delete;
    return this.productService.updateOne(photo, body.photo, del);
  }

  @Put()
  @UseInterceptors(FileInterceptor('new_photo'))
  update(@UploadedFile() photo: Express.Multer.File, @Body() body: any) {
    const del: boolean = body.delete === 'si' ? true : false;
    delete body.delete;
    return this.productService.update(photo, body, del);
  }

  @Delete('deleteall')
  removeAll(@Profile() user: JWToken) {
    return this.productService.removeAll(user.userId);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.productService.remove(id);
  }
}
