import { ProductsService } from './products.service';
import { ProductsController } from './products.controller';
import { Module } from '@nestjs/common';
import { MongooseModule } from '@nestjs/mongoose';
import { JwtModule } from '@nestjs/jwt';
import { UserSchema } from '@schemas/user.schema';
import { BusinessSchema } from '@schemas/business.schema';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { MultimediaService } from '@services/multimedia.service';
import { ProductSchema } from '@schemas/product.schema';
import { GameTypeSchema } from '@schemas/game-type.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'business', schema: BusinessSchema },
      { name: 'products', schema: ProductSchema },
      { name: 'gametypes', schema: GameTypeSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [ProductsController],
  providers: [ProductsService, JwtStrategy, MultimediaService],
})
export class ProductsModule {}
