/* eslint-disable @typescript-eslint/no-unsafe-argument */
import { Profile } from '@common/guards/profile.decorator';
import { JWToken } from '@dtos/general.interface';
import {
  Body,
  Controller,
  Delete,
  Get,
  Param,
  Post,
  Put,
  UseGuards,
} from '@nestjs/common';
import { AuthGuard } from '@nestjs/passport';
import { ApiBearerAuth } from '@nestjs/swagger';
import { SalesService } from './sales.service';

@ApiBearerAuth()
@Controller('sales')
@UseGuards(AuthGuard('jwt'))
export class SalesController {
  constructor(private readonly salesService: SalesService) {}

  @Post()
  create(@Body() createSaleDto: any) {
    return this.salesService.create(createSaleDto);
  }

  // Productos disponibles y tangibles para punto de venta
  @Get('products')
  findAllProducts(@Profile() user: JWToken) {
    return this.salesService.findAllProducts(user.userId);
  }

  // Productos disponibles 60 días a partir de su fecha de sorte para pagar premios
  @Get('products-old')
  findAllProductsOld(@Profile() user: JWToken) {
    return this.salesService.findAllProductsOld(user.userId);
  }

  // Productos que no tienen fecha de sorteo para punto de venta
  @Get('nodate-products')
  findAllNoDateProducts(@Profile() user: JWToken) {
    return this.salesService.findAllNoDateProducts(user.userId);
  }

  // Productos disponibles e intangibles para punto de venta
  @Get('noproducts')
  findAllNoProducts(@Profile() user: JWToken) {
    return this.salesService.findAllNoProducts(user.userId);
  }

  // Obtiene la cantidad de ventas por producto o boleto
  @Get('all-sales')
  findAllsales(@Profile() user: JWToken) {
    return this.salesService.findAllSales(user.userId);
  }

  @Get()
  findAll() {
    return this.salesService.findAll();
  }

  @Get(':id')
  findOne(@Param('id') id: string) {
    return this.salesService.findOne(id);
  }

  @Put(':id')
  update(@Param('id') id: string, @Body() updateSaleDto: any) {
    return this.salesService.update(id, updateSaleDto);
  }

  @Delete('all')
  removeAll(@Profile() user: JWToken) {
    return this.salesService.removeAll(user.userId);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.salesService.remove(id);
  }
}
