import { SalesService } from './sales.service';
import { SalesController } from './sales.controller';
import { Module } from '@nestjs/common';
import { JwtModule } from '@nestjs/jwt';
import { MongooseModule } from '@nestjs/mongoose';
import { BusinessSchema } from '@schemas/business.schema';
import { ProductSchema } from '@schemas/product.schema';
import { ShoppingSchema } from '@schemas/shopping.schema';
import { UserSchema } from '@schemas/user.schema';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { SaleSchema } from '@schemas/sale.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'business', schema: BusinessSchema },
      { name: 'products', schema: ProductSchema },
      { name: 'shoppings', schema: ShoppingSchema },
      { name: 'sales', schema: SaleSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [SalesController],
  providers: [SalesService, JwtStrategy],
})
export class SalesModule {}
