import { BusinessSchema } from '@schemas/business.schema';
import { ShoppingsController } from './shoppings.controller';
import { ShoppingsService } from './shoppings.service';
import { Module } from '@nestjs/common';
import { UserSchema } from '@schemas/user.schema';
import { ProductSchema } from '@schemas/product.schema';
import { MongooseModule } from '@nestjs/mongoose';
import { JwtModule } from '@nestjs/jwt';
import { ShoppingSchema } from '@schemas/shopping.schema';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { SaleSchema } from '@schemas/sale.schema';
import { FinanzasSchema } from '@schemas/finanzas.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'business', schema: BusinessSchema },
      { name: 'products', schema: ProductSchema },
      { name: 'shoppings', schema: ShoppingSchema },
      { name: 'sales', schema: SaleSchema },
      { name: 'finanzas', schema: FinanzasSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [ShoppingsController],
  providers: [ShoppingsService, JwtStrategy],
  exports: [ShoppingsService],
})
export class ShoppingsModule {}
