import { UsersService } from './users.service';
import { UsersController } from './users.controller';
import { Module } from '@nestjs/common';
import { MongooseModule } from '@nestjs/mongoose';
import { UserSchema } from '@schemas/user.schema';
import { JwtModule } from '@nestjs/jwt';
import { JwtStrategy } from '@common/jwt/jwt.strategy';
import { CryptoService } from '@services/crypto.service';
import { MultimediaService } from '@services/multimedia.service';
import { BusinessSchema } from '@schemas/business.schema';
import { UserLogsSchema } from '@schemas/user-logs.schema';

@Module({
  imports: [
    MongooseModule.forFeature([
      { name: 'users', schema: UserSchema },
      { name: 'userlogs', schema: UserLogsSchema },
      { name: 'business', schema: BusinessSchema },
    ]),
    JwtModule.registerAsync({
      useFactory: () => ({
        secret: process.env.JWT_SECRET,
        signOptions: { expiresIn: process.env.JWT_EXPIRES_IN },
      }),
    }),
  ],
  controllers: [UsersController],
  providers: [UsersService, JwtStrategy, CryptoService, MultimediaService],
  exports: [UsersService],
})
export class UsersModule {}
