import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document } from 'mongoose';

export type BusinessDocument = Business & Document;

@Schema({ timestamps: true })
export class Business {
  @Prop({ required: true })
  name: string;

  @Prop({ required: true })
  address: string;

  @Prop({ required: true })
  postal: string;

  @Prop({ required: true })
  city: string;

  @Prop({ required: true })
  state: string;

  @Prop({ default: "" })
  agentName: string;

  @Prop({ default: [] })
  email: string[];

  @Prop({ default: [] })
  phone: string[];

  @Prop({ default: [] })
  mobile: string[];

  @Prop({ default: [] })
  business_hours: string[];

  @Prop({ default: false })
  main: boolean;
}

export const BusinessSchema = SchemaFactory.createForClass(Business);
