import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';
import { ValesSchema } from './vales.schema';
import { DenominacionSchema } from './denominacion.schema';

@Schema({ timestamps: true })
export class CashCount {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ required: true })
  userEmail: string;

  @Prop() venta_producto: number;
  @Prop() efvo_producto: number;
  @Prop() pago_producto: number;
  @Prop() pago_producto_efvo: number;
  @Prop() tarjeta_producto: number;
  @Prop() tarjeta_producto_tax: number;

  @Prop() venta_servicio: number;
  @Prop() pago_servicio: number;
  @Prop() tarjeta_servicio: number;
  @Prop() tarjeta_servicio_tax: number;

  @Prop() venta_apuesta: number;
  @Prop() efvo_apuesta: number;
  @Prop() pago_apuesta: number;
  @Prop() pago_apuesta_efvo: number;
  @Prop() tarjeta_apuesta: number;
  @Prop() tarjeta_apuesta_tax: number;

  @Prop() efvo_ttl_venta: number;

  @Prop() vales: number;
  @Prop({ type: [ValesSchema], default: [] }) vales_items: any[];

  @Prop() efvo_real_venta: number;
  @Prop() venta_total: number;
  @Prop() fondo_caja: number;
  @Prop() diferencia: number;
  @Prop() retiro_efectivo: number;
  @Prop() efvo_contado: number;
  @Prop() caja_recibe: number;
  @Prop() caja_entrega: number;
  @Prop() observaciones: string;

  @Prop({
    type: {
      monedas: { type: [DenominacionSchema], default: [] },
      billetes: { type: [DenominacionSchema], default: [] },
    },
    default: {},
  })
  arqueo: {
    monedas: any[];
    billetes: any[];
  };

  @Prop() turno: string;

  @Prop()
  createdAt?: Date;

  @Prop()
  updatedAt?: Date;
}

export type CashCountDocument = CashCount & Document;
export const CashCountSchema = SchemaFactory.createForClass(CashCount);
