import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Schema as MongooseSchema } from 'mongoose';

@Schema({ timestamps: true }) // Importante
export class Item {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'products',
    required: true,
  })
  productId: MongooseSchema.Types.ObjectId;

  @Prop({ default: new Date() })
  fecha?: Date;

  @Prop({ default: '' })
  sorteo?: string;

  @Prop({ default: 'default.jpg' })
  photo?: string;

  @Prop({ default: 0 })
  dotacion: number;

  @Prop({ default: 0 })
  costo_total: number;

  @Prop({ default: 0 })
  precio_total: number;

  @Prop({ default: 0 })
  pago_anticipado: number;

  @Prop({ default: 0 })
  saldo_x_pagar: number;

  @Prop({ default: 0 })
  devolucion?: number;

  @Prop({ default: '' })
  identificador: string;
}

export const ItemSchema = SchemaFactory.createForClass(Item);
