import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';

@Schema({ timestamps: true })
export class Product {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ type: MongooseSchema.Types.ObjectId, ref: 'users', required: true })
  userId: MongooseSchema.Types.ObjectId;

  @Prop({ required: true })
  identificador: string;

  @Prop({ required: true })
  categoria: string;

  @Prop({ required: true })
  clave: string;

  @Prop({ default: 0 })
  comision: number;

  @Prop({ default: '' })
  observaciones: string;

  @Prop({ default: '' })
  code_bar: string;

  @Prop({ default: 'default.jpg' })
  photo: string;

  @Prop({ default: true })
  exists: boolean;

  @Prop({ default: false })
  bet: boolean;
}

export type ProductDocument = Product & Document;
export const ProductSchema = SchemaFactory.createForClass(Product);
