import { Item, ItemSchema } from './item.schema';
import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { Document, Schema as MongooseSchema } from 'mongoose';
import { Saldos, SaldosSchema } from './saldos.schema';
import { Devoluciones, DevolucionesSchema } from './devoluciones.schema';

@Schema({ timestamps: true })
export class Shopping {
  @Prop({
    type: MongooseSchema.Types.ObjectId,
    ref: 'business',
    required: true,
  })
  businessId: MongooseSchema.Types.ObjectId;

  @Prop({ required: true })
  userEmail: string;

  @Prop({ type: [ItemSchema], default: [] })
  products: Item[];

  @Prop({ type: [SaldosSchema], default: [] })
  saldos: Saldos[];

  @Prop({ type: [DevolucionesSchema], default: [] })
  devoluciones: Devoluciones[];
}

export type ShoppingDocument = Shopping & Document;
export const ShoppingSchema = SchemaFactory.createForClass(Shopping);
